/*---------------------------------------------------------------------------*\

	FILE....: digmw.cpp
	TYPE....: C Program
	AUTHOR..: David Rowe
	DATE....: 23/2/02

	Test program that plays a digital milliwatt tone out of one port. 
\*--------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2002 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../src/vpbapi.h"
#include "kbhit.h"

char digmw[] = {0x1e, 0x0b, 0x0b, 0x1e, 0x9e, 0x8b, 0x8b, 0x9e};

int arg_exists(int argc, char *argv[], char *arg);

int main(int argc, char *argv[]) 
{
	int	      h, arg;

	if (argc == 1) {
		printf("usage: ./digmw Ch[1..] [--handset]\n");
		exit(0);
	}
	h = vpb_open(1,atoi(argv[1]));

	if ((arg = arg_exists(argc,argv,"--handset"))) {
		// port is a handset port (special mod to OpenLine4)
		printf("handset.....\n");
		vpb_set_codec_reg(h, 0x12, 0x7c);
	        vpb_set_codec_reg(h, 0x0a, 0x20); 
	}

	vpb_sethook_sync(h, VPB_OFFHOOK);
	printf("Playing digital milliwatt, hit return to stop\n");

	vpb_play_buf_start(h, VPB_MULAW);
	
	while(!kbhit()) {
		vpb_play_buf_sync(h, digmw, sizeof(digmw));
	}

	vpb_play_buf_finish(h);
	vpb_sethook_sync(h, VPB_ONHOOK);
	vpb_close(h);	

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}



